/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.rei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.compat.rei.CreateCategory;
import com.zurrtum.create.client.compat.rei.renderer.TwoIconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.BasinBlazeBurnerRenderState;
import com.zurrtum.create.client.foundation.gui.render.PressBasinRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.compat.rei.display.CompactingDisplay;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import com.zurrtum.create.content.processing.recipe.ProcessingOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class CompactingCategory
extends CreateCategory<CompactingDisplay> {
    public CategoryIdentifier<? extends CompactingDisplay> getCategoryIdentifier() {
        return ReiCommonPlugin.PACKING;
    }

    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.packing", new Object[0]);
    }

    public Renderer getIcon() {
        return new TwoIconRenderer((class_1792)AllItems.MECHANICAL_PRESS, (class_1792)AllItems.BASIN);
    }

    @Override
    public void addWidgets(List<Widget> widgets, CompactingDisplay display, Rectangle bounds) {
        int i;
        List<EntryIngredient> ingredients = display.inputs();
        ArrayList<Point> points = new ArrayList<Point>();
        ArrayList<Point> outputs = new ArrayList<Point>();
        ArrayList<EntryIngredient> outputIngredients = new ArrayList<EntryIngredient>();
        ArrayList<Point> chances = new ArrayList<Point>();
        ArrayList<EntryIngredient> chanceIngredients = new ArrayList<EntryIngredient>();
        List<ProcessingOutput> results = display.outputs();
        int size = ingredients.size();
        int xOffset = bounds.x + 17 + (size < 3 ? (3 - size) * 19 / 2 : 0);
        int yOffset = bounds.y + (size <= 9 ? 56 : 65);
        for (int i2 = 0; i2 < size; ++i2) {
            points.add(new Point(xOffset + i2 % 3 * 19, yOffset - i2 / 3 * 19));
        }
        int resultSize = results.size();
        boolean isOddSize = resultSize % 2 != 0;
        int end = resultSize - 1;
        int start = bounds.x;
        int y = bounds.y + 56;
        for (int i3 = 0; i3 < resultSize; ++i3) {
            int xPosition = isOddSize && i3 == end ? start + 147 : start + (i3 % 2 == 0 ? 137 : 156);
            int yPosition = -19 * (i3 / 2) + y;
            CompactingCategory.addOutputData(results.get(i3), xPosition, yPosition, outputs, outputIngredients, chances, chanceIngredients);
        }
        HeatCondition requiredHeat = display.heat();
        widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            CompactingCategory.drawSlotBackground(graphics, points, new Point[0]);
            CompactingCategory.drawSlotBackground(graphics, outputs, new Point[0]);
            CompactingCategory.drawChanceSlotBackground(graphics, chances);
            AllGuiTextures.JEI_DOWN_ARROW.render(graphics, bounds.x + 141, bounds.y + (resultSize <= 4 ? 37 : 46) - (resultSize - 1) / 2 * 19);
            Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)graphics.method_51448());
            if (requiredHeat == HeatCondition.NONE) {
                AllGuiTextures.JEI_NO_HEAT_BAR.render(graphics, bounds.x + 9, bounds.y + 85);
                AllGuiTextures.JEI_SHADOW.render(graphics, bounds.x + 86, bounds.y + 73);
            } else {
                AllGuiTextures.JEI_HEAT_BAR.render(graphics, bounds.x + 9, bounds.y + 85);
                AllGuiTextures.JEI_LIGHT.render(graphics, bounds.x + 86, bounds.y + 93);
                graphics.field_59826.method_70922((class_11256)new BasinBlazeBurnerRenderState(pose, bounds.x + 96, bounds.y + 74, requiredHeat.visualizeAsBlazeBurner()));
            }
            graphics.field_59826.method_70922((class_11256)new PressBasinRenderState(pose, bounds.x + 96, bounds.y));
            graphics.method_51439(class_310.method_1551().field_1772, (class_2561)CreateLang.translateDirect(requiredHeat.getTranslationKey(), new Object[0]), bounds.x + 14, bounds.y + 91, requiredHeat.getColor(), false);
        }));
        int size2 = points.size();
        for (i = 0; i < size2; ++i) {
            widgets.add((Widget)CompactingCategory.createInputSlot((Point)points.get(i)).entries((Collection)CompactingCategory.getRenderEntryStack(ingredients.get(i))));
        }
        size2 = outputs.size();
        for (i = 0; i < size2; ++i) {
            widgets.add((Widget)CompactingCategory.createOutputSlot((Point)outputs.get(i)).entries((Collection)outputIngredients.get(i)));
        }
        size2 = chances.size();
        for (i = 0; i < size2; ++i) {
            widgets.add((Widget)CompactingCategory.createOutputSlot((Point)chances.get(i)).entries((Collection)chanceIngredients.get(i)));
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            widgets.add((Widget)CompactingCategory.createSlot(new Point(bounds.x + 139, bounds.y + 86)).entries((Collection)EntryIngredients.of((class_1935)AllItems.BLAZE_BURNER)));
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            widgets.add((Widget)CompactingCategory.createSlot(new Point(bounds.x + 158, bounds.y + 86)).entries((Collection)EntryIngredients.of((class_1935)AllItems.BLAZE_CAKE)));
        }
    }

    public int getDisplayHeight() {
        return 113;
    }
}

